/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class FluidTransformBarrelMode
extends AbstractBarrelMode {
    private int currentProgress = 0;
    private IItemProvider catalyst;

    public FluidTransformBarrelMode(String name) {
        super(name);
    }

    public void setCatalyst(IItemProvider catalyst) {
        this.catalyst = catalyst;
    }

    @Override
    public void tick(AbstractBarrelTile barrelTile) {
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        ++this.currentProgress;
        this.spawnParticle(barrelTile);
        if (this.currentProgress >= Config.getSecondsToFluidTransform() * 20) {
            this.currentProgress = 0;
            Fluid newFluid = ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.getResult(fluidInTank, this.catalyst);
            barrelTile.getTank().setFluid(new FluidStack(newFluid, AbstractBarrelTile.MAX_FLUID_AMOUNT));
            barrelTile.setMode("fluid");
        }
    }

    @Override
    public ActionResultType onBlockActivated(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn, IFluidHandler fluidHandler, IItemHandler itemHandler) {
        return ActionResultType.PASS;
    }

    @Override
    public boolean canFillWithFluid(AbstractBarrelTile barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(ItemStack stack) {
        return false;
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.currentProgress = nbt.func_74762_e("currentProgress");
        this.catalyst = ItemStack.func_199557_a((CompoundNBT)nbt).func_77973_b();
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("currentProgress", this.currentProgress);
        new ItemStack(this.catalyst).func_77955_b(nbt);
        return nbt;
    }

    @Override
    protected void spawnParticle(AbstractBarrelTile barrelTile) {
        ((ServerWorld)barrelTile.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197620_m, (double)barrelTile.func_174877_v().func_177958_n() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177956_o() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177952_p() + barrelTile.func_145831_w().field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    public List<ITextComponent> getWailaInfo(AbstractBarrelTile barrelTile) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        info.add((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)this.currentProgress / (float)(Config.getSecondsToFluidTransform() * 20)))}));
        return info;
    }

    @Override
    public ItemStack handleInsert(AbstractBarrelTile barrelTile, ItemStack stack, boolean simulate) {
        return stack;
    }
}

