/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.BlockBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.CompostBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.EmptyBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.FluidTransformBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.FluidsBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.MobSpawnBarrelMode;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class BarrelModeRegistry {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private static final Map<String, Supplier<AbstractBarrelMode>> modeNameMap = new HashMap<String, Supplier<AbstractBarrelMode>>();
    private static final Map<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>> modeMap = new EnumMap<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>>(TriggerType.class);

    public static AbstractBarrelMode getModeFromName(String barrelMode) {
        return (AbstractBarrelMode)((Supplier)modeNameMap.getOrDefault(barrelMode, null)).get();
    }

    public static List<Supplier<AbstractBarrelMode>> getModes(TriggerType type) {
        logger.debug("Getting barrel mode, Trigger: " + (Object)((Object)type));
        return modeMap.get((Object)type);
    }

    public static void initialize() {
        logger.debug("Adding barrel modes");
        BarrelModeRegistry.addMode(() -> new EmptyBarrelMode("empty"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new CompostBarrelMode("compost"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new FluidsBarrelMode("fluid"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new BlockBarrelMode("block"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new MobSpawnBarrelMode("mob"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new FluidTransformBarrelMode("transform"), TriggerType.NONE);
    }

    public static void addMode(Supplier<AbstractBarrelMode> mode, TriggerType type) {
        logger.debug("Adding mode: " + mode.toString() + ", Trigger: " + (Object)((Object)type));
        ArrayList<Supplier<AbstractBarrelMode>> list = modeMap.get((Object)type);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(mode);
        modeMap.put(type, list);
        modeNameMap.put(mode.get().getModeName(), mode);
    }

    public static enum TriggerType {
        ITEM,
        FLUID,
        NONE;

    }
}

