/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class HandshakeMessages {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    private HandshakeMessages() {
    }

    static class C2SAcknowledge
    extends LoginIndexedMessage {
        C2SAcknowledge() {
        }

        static C2SAcknowledge decode(PacketBuffer buf) {
            return new C2SAcknowledge();
        }

        void encode(PacketBuffer buf) {
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }
    }

    public static class S2COreList
    extends LoginIndexedMessage {
        private List<EnumOre> oreList;

        public List<EnumOre> getOreList() {
            return this.oreList;
        }

        static S2COreList decode(PacketBuffer buffer) {
            S2COreList message = new S2COreList();
            message.oreList = new ArrayList<EnumOre>();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                EnumOre ore = (EnumOre)buffer.func_179257_a(EnumOre.class);
                message.oreList.add(ore);
            }
            logger.debug("Created ore list: " + message.oreList);
            return message;
        }

        void encode(PacketBuffer buffer) {
            this.oreList = Arrays.stream(EnumOre.values()).filter(EnumOre::isEnabled).collect(Collectors.toList());
            logger.debug("Writing ore list: " + this.oreList);
            buffer.writeInt(this.oreList.size());
            for (EnumOre ore : this.oreList) {
                buffer.func_179249_a((Enum)ore);
            }
        }
    }
}

