/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.loot.modifier;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.api.ExNihiloTags;
import novamachina.exnihilosequentia.api.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class UseHammerModifier
extends LootModifier {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final Random random = new Random();

    public UseHammerModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        logger.debug("Fired Hammer Modifier");
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        if (tool != null && blockState != null && ExNihiloTags.HAMMER.func_230235_a_((Object)tool.func_77973_b()) && ExNihiloRegistries.HAMMER_REGISTRY.isHammerable(blockState.func_177230_c())) {
            List<ItemStackWithChance> list = ExNihiloRegistries.HAMMER_REGISTRY.getResult(blockState.func_177230_c());
            for (ItemStackWithChance stackWithChance : list) {
                if (!(this.random.nextFloat() <= stackWithChance.getChance()) || stackWithChance.getStack() == ItemStack.field_190927_a) continue;
                newLoot.add(stackWithChance.getStack());
            }
        }
        if (!newLoot.isEmpty()) {
            logger.debug("Adding new loot");
            generatedLoot = newLoot;
        }
        logger.debug("Hammer Generated Loot: " + generatedLoot);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<UseHammerModifier> {
        public UseHammerModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new UseHammerModifier(ailootcondition);
        }

        public JsonObject write(UseHammerModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

