/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.init;

import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.compost.CompostRecipe;
import novamachina.exnihilosequentia.api.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.api.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.api.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.crafting.serializer.CompostRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.CrookRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.CrucibleRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.FluidItemRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.FluidOnTopRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.FluidTransformRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.HammerRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.HeatRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.serializer.SieveRecipeSerializer;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class ExNihiloSerializers {
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"exnihilosequentia");
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    private ExNihiloSerializers() {
    }

    public static void init(IEventBus modEventBus) {
        logger.debug("Register recipe serializers");
        RECIPE_SERIALIZERS.register(modEventBus);
    }

    static {
        HammerRecipe.setSerializer((RegistryObject<RecipeSerializer<HammerRecipe>>)RECIPE_SERIALIZERS.register("hammer", HammerRecipeSerializer::new));
        CrookRecipe.setSerializer((RegistryObject<RecipeSerializer<CrookRecipe>>)RECIPE_SERIALIZERS.register("crook", CrookRecipeSerializer::new));
        CompostRecipe.setSerializer((RegistryObject<RecipeSerializer<CompostRecipe>>)RECIPE_SERIALIZERS.register("compost", CompostRecipeSerializer::new));
        FluidItemRecipe.setSerializer((RegistryObject<RecipeSerializer<FluidItemRecipe>>)RECIPE_SERIALIZERS.register("fluid_item", FluidItemRecipeSerializer::new));
        FluidOnTopRecipe.setSerializer((RegistryObject<RecipeSerializer<FluidOnTopRecipe>>)RECIPE_SERIALIZERS.register("fluid_on_top", FluidOnTopRecipeSerializer::new));
        FluidTransformRecipe.setSerializer((RegistryObject<RecipeSerializer<FluidTransformRecipe>>)RECIPE_SERIALIZERS.register("fluid_transform", FluidTransformRecipeSerializer::new));
        CrucibleRecipe.setSerializer((RegistryObject<RecipeSerializer<CrucibleRecipe>>)RECIPE_SERIALIZERS.register("crucible", CrucibleRecipeSerializer::new));
        HeatRecipe.setSerializer((RegistryObject<RecipeSerializer<HeatRecipe>>)RECIPE_SERIALIZERS.register("heat", HeatRecipeSerializer::new));
        SieveRecipe.setSerializer((RegistryObject<RecipeSerializer<SieveRecipe>>)RECIPE_SERIALIZERS.register("sieve", SieveRecipeSerializer::new));
    }
}

