/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.datagen;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SmithingRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import novamachina.exnihilosequentia.api.ExNihiloTags;
import novamachina.exnihilosequentia.api.crafting.compost.CompostRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.crook.CrookRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.fluidontop.FluidOnTopRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.fluidtransform.FluidTransformRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipeBuilder;
import novamachina.exnihilosequentia.api.datagen.AbstractRecipeGenerator;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloFluids;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.dolls.EnumDoll;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;
import novamachina.exnihilosequentia.common.item.pebbles.EnumPebbleType;
import novamachina.exnihilosequentia.common.item.resources.EnumResource;
import novamachina.exnihilosequentia.common.item.seeds.EnumSeed;
import novamachina.exnihilosequentia.common.item.tools.crook.EnumCrook;
import novamachina.exnihilosequentia.common.item.tools.hammer.EnumHammer;
import novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;

public class ExNihiloRecipeGenerator
extends AbstractRecipeGenerator {
    private static final String COBBLESTONE = "cobblestone";
    private static final String DOLL_CONDITION = "has_doll";
    private static final String GRAVEL_SUFFIX = "_gravel";
    private static final String LEAVES = "leaves";
    private static final String MATERIAL_CONDITION = "has_material";
    private static final String NETHERRACK = "netherrack";
    private static final String PEBBLE_CONDITION = "has_pebble";
    private static final String PORCELAIN_CLAY_CONDITION = "has_porcelain_clay";

    public ExNihiloRecipeGenerator(DataGenerator generator) {
        super(generator, "exnihilosequentia");
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerCrooks(consumer);
        this.registerPebbleBlocks(consumer);
        this.registerBarrels(consumer);
        this.registerOres(consumer);
        this.registerHammers(consumer);
        this.registerDolls(consumer);
        this.registerMeshes(consumer);
        this.registerMisc(consumer);
        this.registerCustomRecipes(consumer);
    }

    private Map<Block, Item> getLeavesSaplings() {
        HashMap<Block, Item> saplingMap = new HashMap<Block, Item>();
        saplingMap.put(Blocks.field_196572_aa, Items.field_221596_x);
        saplingMap.put(Blocks.field_196647_Y, Items.field_221594_v);
        saplingMap.put(Blocks.field_196574_ab, Items.field_221597_y);
        saplingMap.put(Blocks.field_196648_Z, Items.field_221595_w);
        saplingMap.put(Blocks.field_196642_W, Items.field_221592_t);
        saplingMap.put(Blocks.field_196645_X, Items.field_221593_u);
        return saplingMap;
    }

    private void registerBarrels(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.BARREL_STONE.get())).func_200472_a("x x").func_200472_a("x x").func_200472_a("x-x").func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('-'), (IItemProvider)Blocks.field_150333_U).func_200473_b("exnihilosequentia").func_200465_a("has_walls", (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)Tags.Items.STONE)).func_200465_a("has_base", (ICriterionInstance)ExNihiloRecipeGenerator.func_200403_a((IItemProvider)Blocks.field_150333_U)).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.BARREL_STONE.getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.BARREL_WOOD.get())).func_200472_a("x x").func_200472_a("x x").func_200472_a("x-x").func_200469_a(Character.valueOf('x'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('-'), (ITag)ItemTags.field_202899_i).func_200473_b("exnihilosequentia").func_200465_a("has_walls", (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)ItemTags.field_199905_b)).func_200465_a("has_base", (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)ItemTags.field_202899_i)).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.BARREL_WOOD.getId()));
    }

    private void registerCompostRecipes(Consumer<IFinishedRecipe> consumer) {
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)ItemTags.field_200037_g).amount(125).build(consumer, this.compostLoc("saplings"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)ItemTags.field_206963_E).amount(125).build(consumer, this.compostLoc(LEAVES));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)ItemTags.field_226159_I_).amount(100).build(consumer, this.compostLoc("flowers"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)ItemTags.field_206964_G).amount(150).build(consumer, this.compostLoc("fishes"));
        CompostRecipeBuilder.builder().input(ExNihiloTags.MEAT_COOKED).amount(200).build(consumer, this.compostLoc("meat_cooked"));
        CompostRecipeBuilder.builder().input(ExNihiloTags.MEAT_UNCOOKED).amount(200).build(consumer, this.compostLoc("meat_uncooked"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.SEEDS).amount(80).build(consumer, this.compostLoc("seeds"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.CROPS_WHEAT).amount(80).build(consumer, this.compostLoc("wheat"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.CROPS_CARROT).amount(100).build(consumer, this.compostLoc("carrot"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.CROPS_BEETROOT).amount(100).build(consumer, this.compostLoc("beetroot"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.CROPS_POTATO).amount(100).build(consumer, this.compostLoc("potato"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.CROPS_NETHER_WART).amount(100).build(consumer, this.compostLoc("nether_wart"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.EGGS).amount(80).build(consumer, this.compostLoc("eggs"));
        CompostRecipeBuilder.builder().input((ITag.INamedTag<Item>)Tags.Items.STRING).amount(40).build(consumer, this.compostLoc("string"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151078_bh).amount(100).build(consumer, this.compostLoc("rotten_flesh"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151070_bp).amount(80).build(consumer, this.compostLoc("spider_eye"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151025_P).amount(160).build(consumer, this.compostLoc("bread"));
        CompostRecipeBuilder.builder().input((IItemProvider)Blocks.field_150338_P).amount(100).build(consumer, this.compostLoc("brown_mushroom"));
        CompostRecipeBuilder.builder().input((IItemProvider)Blocks.field_150337_Q).amount(100).build(consumer, this.compostLoc("red_mushroom"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_234722_bw_).amount(100).build(consumer, this.compostLoc("crimson_fungus"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_234723_bx_).amount(100).build(consumer, this.compostLoc("warped_fungus"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151158_bO).amount(160).build(consumer, this.compostLoc("pumpkin_pie"));
        CompostRecipeBuilder.builder().input((IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()).amount(40).build(consumer, this.compostLoc("silkworm"));
        CompostRecipeBuilder.builder().input((IItemProvider)ExNihiloItems.COOKED_SILKWORM.get()).amount(40).build(consumer, this.compostLoc("cooked_silkworm"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151034_e).amount(100).build(consumer, this.compostLoc("apple"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151127_ba).amount(40).build(consumer, this.compostLoc("melon_slice"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221794_dg).amount(166).build(consumer, this.compostLoc("melon"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221687_cF).amount(166).build(consumer, this.compostLoc("pumpkin"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221689_cG).amount(166).build(consumer, this.compostLoc("carved_pumpkin"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221697_cK).amount(166).build(consumer, this.compostLoc("jack_o_lantern"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221774_cw).amount(100).build(consumer, this.compostLoc("cactus"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151168_bH).amount(150).build(consumer, this.compostLoc("baked_potato"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_151170_bI).amount(200).build(consumer, this.compostLoc("poisonous_potato"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221816_dr).amount(100).build(consumer, this.compostLoc("lily_pad"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221796_dh).amount(100).build(consumer, this.compostLoc("vine"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_234718_bB_).amount(100).build(consumer, this.compostLoc("weeping_vine"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_234719_bC_).amount(100).build(consumer, this.compostLoc("twisting_vine"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_221916_fp).amount(100).build(consumer, this.compostLoc("tall_grass"));
        CompostRecipeBuilder.builder().input((IItemProvider)Items.field_222065_kN).amount(80).build(consumer, this.compostLoc("sugar_cane"));
    }

    private void registerCrook(Item result, Item input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("xx").func_200472_a(" x").func_200472_a(" x").func_200462_a(Character.valueOf('x'), (IItemProvider)input).func_200473_b("exnihilosequentia").func_200465_a(PEBBLE_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_200467_a(consumer, this.createSaveLocation(result.getRegistryName()));
    }

    private void registerCrook(Item result, ITag.INamedTag<Item> input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("xx").func_200472_a(" x").func_200472_a(" x").func_200469_a(Character.valueOf('x'), input).func_200473_b("exnihilosequentia").func_200465_a(PEBBLE_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(input).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(result.getRegistryName()));
    }

    private void registerCrookRecipes(Consumer<IFinishedRecipe> consumer) {
        CrookRecipeBuilder.builder().input((ITag.INamedTag<Item>)ItemTags.field_206963_E).addDrop((IItemProvider)EnumResource.SILKWORM.getRegistryObject().get(), 0.1f).build(consumer, this.crookLoc(LEAVES));
    }

    private void registerCrooks(Consumer<IFinishedRecipe> consumer) {
        this.registerCrook((Item)EnumCrook.ANDESITE.getRegistryObject().get(), (Item)EnumPebbleType.ANDESITE.getRegistryObject().get(), consumer);
        this.registerCrook((Item)EnumCrook.BONE.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.BONES, consumer);
        this.registerCrook((Item)EnumCrook.DIAMOND.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.registerCrook((Item)EnumCrook.DIORITE.getRegistryObject().get(), (Item)EnumPebbleType.DIORITE.getRegistryObject().get(), consumer);
        this.registerCrook((Item)EnumCrook.GOLD.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.NUGGETS_GOLD, consumer);
        this.registerCrook((Item)EnumCrook.GRANITE.getRegistryObject().get(), (Item)EnumPebbleType.GRANITE.getRegistryObject().get(), consumer);
        this.registerCrook((Item)EnumCrook.IRON.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.NUGGETS_IRON, consumer);
        this.registerCrook((Item)EnumCrook.STONE.getRegistryObject().get(), ExNihiloTags.STONE_STICK, consumer);
        this.registerCrook((Item)EnumCrook.WOOD.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.RODS_WOODEN, consumer);
    }

    private void registerCrucibleRecipes(Consumer<IFinishedRecipe> consumer) {
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150347_e})).amount(250).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc(COBBLESTONE));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196654_e})).amount(250).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("diorite"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196656_g})).amount(250).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("andesite"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196650_c})).amount(250).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("granite"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150348_b})).amount(250).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("stone"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).amount(200).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("gravel"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_ANDESITE.get()})).amount(200).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("crushed_andesite"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_DIORITE.get()})).amount(200).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("crushed_diorite"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_END_STONE.get()})).amount(200).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("crushed_end_stone"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_GRANITE.get()})).amount(200).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("crushed_granite"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).amount(200).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("crushed_netherrack"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).amount(100).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("sand"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).amount(50).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("dust"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150424_aL})).amount(1000).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc(NETHERRACK));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150343_Z})).amount(1000).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc("obsidian"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_200037_g)).amount(250).fluidResult((Fluid)Fluids.field_204546_a).crucibleType(CrucilbeTypeEnum.WOOD).build(consumer, this.crucibleLoc("saplings"));
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).amount(250).fluidResult((Fluid)Fluids.field_204546_a).crucibleType(CrucilbeTypeEnum.WOOD).build(consumer, this.crucibleLoc(LEAVES));
    }

    private void registerCustomRecipes(Consumer<IFinishedRecipe> consumer) {
        this.registerHammerRecipes(consumer);
        this.registerCrookRecipes(consumer);
        this.registerCompostRecipes(consumer);
        this.registerFluidItemRecipes(consumer);
        this.registerFluidOnTopRecipes(consumer);
        this.registerFluidTransformRecipes(consumer);
        this.registerCrucibleRecipes(consumer);
        this.registerHeatRecipes(consumer);
        this.registerSieveRecipes(consumer);
    }

    private void registerDefaultOres(Consumer<IFinishedRecipe> consumer, EnumOre ore) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.075f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.1f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
    }

    private void registerDolls(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.SHULKER.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.DYES_PURPLE).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.END_STONES).func_200469_a(Character.valueOf('b'), (ITag)Tags.Items.ENDER_PEARLS).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.SHULKER.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.GUARDIAN.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.GEMS_PRISMARINE).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('b'), (ITag)ItemTags.field_206964_G).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.GUARDIAN.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.BEE.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.DYES_YELLOW).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)ItemTags.field_226159_I_).func_200462_a(Character.valueOf('b'), (IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get()).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.BEE.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.BLAZE.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_151065_br).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('b'), (ITag)Tags.Items.CROPS_NETHER_WART).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.BLAZE.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.ENDERMAN.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.DYES_BLACK).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('b'), (ITag)Tags.Items.CROPS_NETHER_WART).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.ENDERMAN.getRegistryObject().getId()));
    }

    private void registerFluidItemRecipes(Consumer<IFinishedRecipe> consumer) {
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)Fluids.field_204546_a).input((IItemProvider)ExNihiloBlocks.DUST.get()).result((IItemProvider)Blocks.field_150435_aG).build(consumer, this.fluidItemLoc("clay"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)Fluids.field_204547_b).input((Tags.IOptionalNamedTag<Item>)Tags.Items.DUSTS_REDSTONE).result((IItemProvider)Blocks.field_150424_aL).build(consumer, this.fluidItemLoc(NETHERRACK));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)Fluids.field_204547_b).input((Tags.IOptionalNamedTag<Item>)Tags.Items.DUSTS_GLOWSTONE).result((IItemProvider)Blocks.field_150377_bs).build(consumer, this.fluidItemLoc("end_stone"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.WITCH_WATER.get()).input((Tags.IOptionalNamedTag<Item>)Tags.Items.SAND).result((IItemProvider)Blocks.field_150425_aM).build(consumer, this.fluidItemLoc("soul_sand"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.WITCH_WATER.get()).input((IItemProvider)Items.field_221583_k).result((IItemProvider)Blocks.field_235336_cN_).build(consumer, this.fluidItemLoc("soul_soil"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.WITCH_WATER.get()).input((Tags.IOptionalNamedTag<Item>)Tags.Items.MUSHROOMS).result((IItemProvider)Blocks.field_180399_cE).build(consumer, this.fluidItemLoc("slime"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.SEA_WATER.get()).input((IItemProvider)EnumResource.BLUE_CORAL_SEED.getRegistryObject().get()).result((IItemProvider)Blocks.field_203963_jE).build(consumer, this.fluidItemLoc("tube_coral"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.SEA_WATER.get()).input((IItemProvider)EnumResource.RED_CORAL_SEED.getRegistryObject().get()).result((IItemProvider)Blocks.field_203966_jH).build(consumer, this.fluidItemLoc("fire_coral"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.SEA_WATER.get()).input((IItemProvider)EnumResource.PINK_CORAL_SEED.getRegistryObject().get()).result((IItemProvider)Blocks.field_203964_jF).build(consumer, this.fluidItemLoc("brain_coral"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.SEA_WATER.get()).input((IItemProvider)EnumResource.PURPLE_CORAL_SEED.getRegistryObject().get()).result((IItemProvider)Blocks.field_203965_jG).build(consumer, this.fluidItemLoc("bubble_coral"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.SEA_WATER.get()).input((IItemProvider)EnumResource.YELLOW_CORAL_SEED.getRegistryObject().get()).result((IItemProvider)Blocks.field_203967_jI).build(consumer, this.fluidItemLoc("horn_coral"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.WITCH_WATER.get()).input((IItemProvider)EnumResource.ANCIENT_SPORE.getRegistryObject().get()).result((IItemProvider)Blocks.field_150420_aW).build(consumer, this.fluidItemLoc("brown_mushroom"));
        FluidItemRecipeBuilder.builder().fluidInBarrel((Fluid)ExNihiloFluids.WITCH_WATER.get()).input((IItemProvider)Blocks.field_150420_aW).result((IItemProvider)Blocks.field_150419_aX).build(consumer, this.fluidItemLoc("red_mushroom"));
    }

    private void registerFluidOnTopRecipes(Consumer<IFinishedRecipe> consumer) {
        FluidOnTopRecipeBuilder.builder().fluidInTank((Fluid)Fluids.field_204547_b).fluidOnTop((Fluid)Fluids.field_204546_a).result((IItemProvider)Blocks.field_150343_Z).build(consumer, this.fluidOnTopLoc("obsidian"));
        FluidOnTopRecipeBuilder.builder().fluidInTank((Fluid)Fluids.field_204546_a).fluidOnTop((Fluid)Fluids.field_204547_b).result((IItemProvider)Blocks.field_150347_e).build(consumer, this.fluidOnTopLoc(COBBLESTONE));
    }

    private void registerFluidTransformRecipes(Consumer<IFinishedRecipe> consumer) {
        FluidTransformRecipeBuilder.builder().fluidInTank((Fluid)Fluids.field_204546_a).catalyst(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150391_bh})).result((Fluid)ExNihiloFluids.WITCH_WATER.get()).build(consumer, this.fluidTransformLoc("witch_water"));
        FluidTransformRecipeBuilder.builder().fluidInTank((Fluid)Fluids.field_204546_a).catalyst(Ingredient.func_199805_a((ITag)Tags.Items.SAND)).result((Fluid)ExNihiloFluids.SEA_WATER.get()).build(consumer, this.fluidTransformLoc("sea_water"));
    }

    private void registerGoldOres(Consumer<IFinishedRecipe> consumer, EnumOre ore) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.25f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.25f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.4f)).build(consumer, this.sieveLoc(ore.getPieceName() + "_crushed_netherrack"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.075f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.15f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
    }

    private void registerHammer(Item output, ITag.INamedTag<Item> input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)output).func_200472_a(" x ").func_200472_a(" -x").func_200472_a("-  ").func_200469_a(Character.valueOf('x'), input).func_200469_a(Character.valueOf('-'), (ITag)Tags.Items.RODS).func_200465_a("has_stick", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.RODS).func_200310_b()})).func_200465_a(MATERIAL_CONDITION, (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a(input)).func_200467_a(consumer, this.createSaveLocation(output.getRegistryName()));
    }

    private void registerHammerRecipes(Consumer<IFinishedRecipe> consumer) {
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_150348_b).addDrop((IItemProvider)Blocks.field_150347_e).build(consumer, this.hammerLoc(COBBLESTONE));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_150347_e).addDrop((IItemProvider)Blocks.field_150351_n).build(consumer, this.hammerLoc("gravel"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_150351_n).addDrop((IItemProvider)Blocks.field_150354_m).build(consumer, this.hammerLoc("sand"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_150354_m).addDrop((IItemProvider)ExNihiloBlocks.DUST.get()).build(consumer, this.hammerLoc("dust"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_150424_aL).addDrop((IItemProvider)ExNihiloBlocks.CRUSHED_NETHERRACK.get()).build(consumer, this.hammerLoc(NETHERRACK));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_196656_g).addDrop((IItemProvider)ExNihiloBlocks.CRUSHED_ANDESITE.get()).build(consumer, this.hammerLoc("andesite"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_196654_e).addDrop((IItemProvider)ExNihiloBlocks.CRUSHED_DIORITE.get()).build(consumer, this.hammerLoc("diorite"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_196650_c).addDrop((IItemProvider)ExNihiloBlocks.CRUSHED_GRANITE.get()).build(consumer, this.hammerLoc("granite"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_150377_bs).addDrop((IItemProvider)ExNihiloBlocks.CRUSHED_END_STONE.get()).build(consumer, this.hammerLoc("end_stone"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_203963_jE).addDrop((IItemProvider)Blocks.field_204278_jJ).build(consumer, this.hammerLoc("tube_coral"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_203964_jF).addDrop((IItemProvider)Blocks.field_204279_jK).build(consumer, this.hammerLoc("brain_coral"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_203965_jG).addDrop((IItemProvider)Blocks.field_204280_jL).build(consumer, this.hammerLoc("bubble_coral"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_203966_jH).addDrop((IItemProvider)Blocks.field_204281_jM).build(consumer, this.hammerLoc("fire_coral"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_203967_jI).addDrop((IItemProvider)Blocks.field_204282_jN).build(consumer, this.hammerLoc("horn_coral"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_204278_jJ).addDrop((IItemProvider)Blocks.field_204743_jR).build(consumer, this.hammerLoc("tube_coral_fan"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_204279_jK).addDrop((IItemProvider)Blocks.field_204744_jS).build(consumer, this.hammerLoc("brain_coral_fan"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_204280_jL).addDrop((IItemProvider)Blocks.field_204745_jT).build(consumer, this.hammerLoc("bubble_coral_fan"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_204281_jM).addDrop((IItemProvider)Blocks.field_204746_jU).build(consumer, this.hammerLoc("fire_coral_fan"));
        HammerRecipeBuilder.builder().input((IItemProvider)Blocks.field_204282_jN).addDrop((IItemProvider)Blocks.field_204747_jV).build(consumer, this.hammerLoc("horn_coral_fan"));
    }

    private void registerHammers(Consumer<IFinishedRecipe> consumer) {
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumHammer.DIAMOND.getRegistryObject().get()}), (Ingredient)Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_NETHERITE), (Item)((Item)EnumHammer.NETHERITE.getRegistryObject().get())).func_240503_a_("has_diamond_hammer", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumHammer.DIAMOND.getRegistryObject().get()})).func_240503_a_(MATERIAL_CONDITION, (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)Tags.Items.INGOTS_NETHERITE)).func_240505_a_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", EnumHammer.NETHERITE.hammerName)));
        this.registerHammer((Item)EnumHammer.DIAMOND.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.registerHammer((Item)EnumHammer.GOLD.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.INGOTS_GOLD, consumer);
        this.registerHammer((Item)EnumHammer.IRON.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.registerHammer((Item)EnumHammer.STONE.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.COBBLESTONE, consumer);
        this.registerHammer((Item)EnumHammer.WOOD.getRegistryObject().get(), (ITag.INamedTag<Item>)ItemTags.field_199905_b, consumer);
    }

    private void registerHeatRecipes(Consumer<IFinishedRecipe> consumer) {
        HeatRecipeBuilder.builder().input(Blocks.field_150353_l).amount(3).build(consumer, this.heatLoc("lava"));
        HeatRecipeBuilder.builder().input(Blocks.field_150480_ab).amount(4).build(consumer, this.heatLoc("fire"));
        HeatRecipeBuilder.builder().input(Blocks.field_150478_aa).amount(1).build(consumer, this.heatLoc("torch"));
        HeatRecipeBuilder.builder().input(Blocks.field_196591_bQ).amount(1).build(consumer, this.heatLoc("wall_torch"));
        HeatRecipeBuilder.builder().input(Blocks.field_196814_hQ).amount(2).build(consumer, this.heatLoc("magma_block"));
        HeatRecipeBuilder.builder().input(Blocks.field_150426_aN).amount(2).build(consumer, this.heatLoc("glowstone"));
        HeatRecipeBuilder.builder().input(Blocks.field_235383_mw_).amount(2).build(consumer, this.heatLoc("shroomlight"));
        HeatRecipeBuilder.builder().input(Blocks.field_235335_bO_).amount(4).build(consumer, this.heatLoc("soul_fire"));
    }

    private void registerIronOres(Consumer<IFinishedRecipe> consumer, EnumOre ore) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.1f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.15f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.25f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.5f)).build(consumer, this.sieveLoc(ore.getPieceName() + "_sand"));
    }

    private void registerMesh(Item output, Item inputMesh, ITag.INamedTag<Item> inputItem, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)output).func_200472_a("i i").func_200472_a("imi").func_200472_a("i i").func_200469_a(Character.valueOf('i'), inputItem).func_200462_a(Character.valueOf('m'), (IItemProvider)inputMesh).func_200465_a("has_mesh", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{inputMesh})).func_200467_a(consumer, this.createSaveLocation(output.getRegistryName()));
    }

    private void registerMesh(Item output, Item inputMesh, Item inputItem, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)output).func_200472_a("i i").func_200472_a("imi").func_200472_a("i i").func_200462_a(Character.valueOf('i'), (IItemProvider)inputItem).func_200462_a(Character.valueOf('m'), (IItemProvider)inputMesh).func_200465_a("has_mesh", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{inputMesh})).func_200467_a(consumer, this.createSaveLocation(output.getRegistryName()));
    }

    private void registerMeshes(Consumer<IFinishedRecipe> consumer) {
        this.registerMesh((Item)EnumMesh.FLINT.getRegistryObject().get(), (Item)EnumMesh.STRING.getRegistryObject().get(), Items.field_151145_ak, consumer);
        this.registerMesh((Item)EnumMesh.IRON.getRegistryObject().get(), (Item)EnumMesh.FLINT.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.registerMesh((Item)EnumMesh.DIAMOND.getRegistryObject().get(), (Item)EnumMesh.IRON.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.registerMesh((Item)EnumMesh.EMERALD.getRegistryObject().get(), (Item)EnumMesh.DIAMOND.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.GEMS_EMERALD, consumer);
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumMesh.EMERALD.getRegistryObject().get()}), (Ingredient)Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_NETHERITE), (Item)((Item)EnumMesh.NETHERITE.getRegistryObject().get())).func_240503_a_("has_emerald_mesh", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumMesh.EMERALD.getRegistryObject().get()})).func_240503_a_(MATERIAL_CONDITION, (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)Tags.Items.INGOTS_NETHERITE)).func_240505_a_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", EnumMesh.NETHERITE.getMeshName())));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumMesh.STRING.getRegistryObject().get())).func_200472_a("iii").func_200472_a("iii").func_200472_a("iii").func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.STRING).func_200465_a("has_sieve", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.SIEVE.get()})).func_200467_a(consumer, this.createSaveLocation(EnumMesh.STRING.getRegistryObject().getId()));
    }

    private void registerMisc(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_226906_mb_).func_200472_a("xxx").func_200472_a("fff").func_200472_a("xxx").func_200469_a(Character.valueOf('x'), (ITag)ItemTags.field_199905_b).func_200462_a(Character.valueOf('f'), (IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get()).func_200465_a("has_frame", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_226906_mb_.getRegistryName()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get())).func_200472_a("xxx").func_200472_a("xfx").func_200472_a("xxx").func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('f'), (ITag)Tags.Items.STRING).func_200465_a("has_stick", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.RODS_WOODEN).func_200310_b()})).func_200465_a("has_string", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.STRING).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(EnumResource.BEEHIVE_FRAME.getRegistryObject().getId()));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()}), (IItemProvider)((IItemProvider)ExNihiloItems.COOKED_SILKWORM.get()), (float)0.1f, (int)200).func_218628_a("has_silkworm", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "cooked_silkworm")));
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()}), (IItemProvider)((IItemProvider)ExNihiloItems.COOKED_SILKWORM.get()), (float)0.1f, (int)600, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a("has_silkworm", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "cooked_silkworm_from_campfilre")));
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()}), (IItemProvider)((IItemProvider)ExNihiloItems.COOKED_SILKWORM.get()), (float)0.1f, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_silkworm", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "cooked_silkworm_from_smoker")));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()}), (IItemProvider)((IItemProvider)ExNihiloItems.COOKED_SILKWORM.get()), (float)0.1f, (int)100).func_218628_a("has_silkworm", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "blast_cooked_silkworm")));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUCIBLE_UNFIRED.get()}), (IItemProvider)((IItemProvider)ExNihiloBlocks.CRUCIBLE_FIRED.get()), (float)0.7f, (int)200).func_218628_a("has_uncooked_crucible", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUCIBLE_UNFIRED.get()})).func_218635_a(consumer, this.createSaveLocation(ExNihiloBlocks.CRUCIBLE_FIRED.getId()));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUCIBLE_UNFIRED.get()}), (IItemProvider)((IItemProvider)ExNihiloBlocks.CRUCIBLE_FIRED.get()), (float)0.7f, (int)100).func_218628_a("has_uncooked_crucible", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUCIBLE_UNFIRED.get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "blast_crucible_fired")));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.CRUCIBLE_UNFIRED.get())).func_200472_a("c c").func_200472_a("c c").func_200472_a("ccc").func_200462_a(Character.valueOf('c'), (IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()).func_200465_a(PORCELAIN_CLAY_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.CRUCIBLE_UNFIRED.getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.CRUCIBLE_WOOD.get())).func_200472_a("c c").func_200472_a("clc").func_200472_a("s s").func_200469_a(Character.valueOf('c'), (ITag)ItemTags.field_200038_h).func_200469_a(Character.valueOf('l'), (ITag)ItemTags.field_202899_i).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_logs", (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)ItemTags.field_200038_h)).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.CRUCIBLE_WOOD.getId()));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()), (int)4).func_200472_a("xex").func_200472_a(" x ").func_200472_a("x x").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()).func_200469_a(Character.valueOf('e'), (ITag)Tags.Items.GEMS_DIAMOND).func_200465_a(PORCELAIN_CLAY_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()})).func_200465_a("has_diamond", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.GEMS_DIAMOND).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x4")));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()), (int)6).func_200472_a("xex").func_200472_a(" x ").func_200472_a("x x").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()).func_200469_a(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).func_200465_a(PORCELAIN_CLAY_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()})).func_200465_a("has_emerald", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.GEMS_EMERALD).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x6")));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.END_CAKE.get())).func_200472_a("ece").func_200472_a("eke").func_200472_a("ece").func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_185158_cP).func_200462_a(Character.valueOf('k'), (IItemProvider)Items.field_222070_lD).func_200465_a("has_ender_pearl", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi})).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.END_CAKE.getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.SIEVE.get())).func_200472_a("p p").func_200472_a("plp").func_200472_a("s s").func_200469_a(Character.valueOf('p'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('l'), (ITag)ItemTags.field_202899_i).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_plank", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)ItemTags.field_199905_b).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.SIEVE.getId()));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get())).func_203221_a(ExNihiloTags.CLAY).func_200487_b((IItemProvider)Items.field_196106_bc).func_200483_a("has_clay", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(ExNihiloTags.CLAY).func_200310_b()})).func_200485_a(consumer, this.createSaveLocation(EnumResource.PORCELAIN_CLAY.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235387_nA_).func_200472_a("xxx").func_200472_a("xgx").func_200472_a("xxx").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumPebbleType.BLACKSTONE.getRegistryObject().get()).func_200462_a(Character.valueOf('g'), (IItemProvider)EnumOre.GOLD.getChunkItem().get()).func_200465_a("has_gold", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumOre.GOLD.getChunkItem().get()})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_235387_nA_.getRegistryName()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235399_ni_).func_200472_a(" o ").func_200472_a("obo").func_200472_a(" o ").func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151131_as).func_200462_a(Character.valueOf('o'), (IItemProvider)Blocks.field_150343_Z).func_200465_a("has_obsidian", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150343_Z})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_235399_ni_.getRegistryName()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235398_nh_).func_200472_a("xxx").func_200472_a("xox").func_200472_a("xxx").func_200462_a(Character.valueOf('x'), (IItemProvider)Items.field_234760_kn_).func_200462_a(Character.valueOf('o'), (IItemProvider)Blocks.field_150343_Z).func_200465_a("has_obsidian", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150343_Z})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_235398_nh_.getRegistryName()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumResource.STONE_STICK.getRegistryObject().get())).func_200472_a("x").func_200472_a("x").func_200472_a("x").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumPebbleType.STONE.getRegistryObject().get()).func_200465_a("has_stone_pebble", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumPebbleType.STONE.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumResource.STONE_STICK.getRegistryObject().getId()));
    }

    private void registerOres(Consumer<IFinishedRecipe> consumer) {
        for (EnumOre ore : EnumOre.values()) {
            this.registerOre(ore, consumer);
            if (!ore.isVanilla()) {
                this.registerSmelting(ore, consumer);
            }
            if (!ore.isVanilla()) continue;
            if (ore == EnumOre.IRON) {
                CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)Items.field_151042_j, (float)0.7f, (int)200).func_218628_a("has_chunk", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("minecraft", "ingot_iron")));
                CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)Items.field_151042_j, (float)0.7f, (int)100).func_218628_a("has_chunk", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("minecraft", "blast_ingot_iron")));
            }
            if (ore != EnumOre.GOLD) continue;
            CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)Items.field_151043_k, (float)0.7f, (int)200).func_218628_a("has_chunk", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("minecraft", "ingot_gold")));
            CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)Items.field_151043_k, (float)0.7f, (int)100).func_218628_a("has_chunk", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation("minecraft", "blast_ingot_gold")));
        }
    }

    private void registerPebbleBlock(Block result, Item input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("xx").func_200472_a("xx").func_200462_a(Character.valueOf('x'), (IItemProvider)input).func_200473_b("exnihilosequentia").func_200465_a(PEBBLE_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_200467_a(consumer, this.createSaveLocation(result.getRegistryName()));
    }

    private void registerPebbleBlocks(Consumer<IFinishedRecipe> consumer) {
        this.registerPebbleBlock(Blocks.field_196656_g, (Item)EnumPebbleType.ANDESITE.getRegistryObject().get(), consumer);
        this.registerPebbleBlock(Blocks.field_150347_e, (Item)EnumPebbleType.STONE.getRegistryObject().get(), consumer);
        this.registerPebbleBlock(Blocks.field_196654_e, (Item)EnumPebbleType.DIORITE.getRegistryObject().get(), consumer);
        this.registerPebbleBlock(Blocks.field_196650_c, (Item)EnumPebbleType.GRANITE.getRegistryObject().get(), consumer);
        this.registerPebbleBlock(Blocks.field_235337_cO_, (Item)EnumPebbleType.BASALT.getRegistryObject().get(), consumer);
        this.registerPebbleBlock(Blocks.field_235406_np_, (Item)EnumPebbleType.BLACKSTONE.getRegistryObject().get(), consumer);
    }

    private void registerSieveRecipes(Consumer<IFinishedRecipe> consumer) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.STONE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 1.0f)).addRoll(new MeshWithChance(EnumMesh.STRING, 1.0f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_stone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.ANDESITE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_andesite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.DIORITE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_diorite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.GRANITE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_granite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.BASALT.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_basalt"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.BLACKSTONE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_blackstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_151014_N)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.7f)).build(consumer, this.sieveLoc("seed_wheat"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_151081_bc)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.35f)).build(consumer, this.sieveLoc("seed_melon"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_151080_bb)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.35f)).build(consumer, this.sieveLoc("seed_pumpkin"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_185163_cU)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.35f)).build(consumer, this.sieveLoc("seed_beetroot"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumResource.ANCIENT_SPORE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).build(consumer, this.sieveLoc("ancient_spore"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumResource.GRASS_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).build(consumer, this.sieveLoc("seed_grass"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_196130_bo)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.03f)).build(consumer, this.sieveLoc("cocoa_beans"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_179562_cC)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.02f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.04f)).build(consumer, this.sieveLoc("prismarine_shard"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_179563_cD)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.01f)).build(consumer, this.sieveLoc("prismarine_crystals"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151145_ak)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.25f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.25f)).build(consumer, this.sieveLoc("flint"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151044_h)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.125f)).build(consumer, this.sieveLoc("coal"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_196128_bn)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).build(consumer, this.sieveLoc("lapis_lazuli"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151045_i)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.008f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.016f)).build(consumer, this.sieveLoc("diamond"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((IItemProvider)Items.field_234760_kn_)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.004f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.008f)).build(consumer, this.sieveLoc("netherite_scrap"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151166_bC)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.008f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.016f)).build(consumer, this.sieveLoc("emerald"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM})).addResult((IItemProvider)Items.field_151128_bU)).addRoll(new MeshWithChance(EnumMesh.FLINT, 1.0f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.33f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 1.0f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.8f)).build(consumer, this.sieveLoc("quartz"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM})).addResult((IItemProvider)Items.field_151075_bm)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("nether_wart"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM})).addResult((IItemProvider)Items.field_151073_bk)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.02f)).build(consumer, this.sieveLoc("ghast_tear"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_196106_bc)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.2f)).build(consumer, this.sieveLoc("bone_meal"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151016_H)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.07f)).build(consumer, this.sieveLoc("gunpowder"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151137_ax)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.125f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.25f)).build(consumer, this.sieveLoc("redstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151114_aO)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.0625f)).build(consumer, this.sieveLoc("glowstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151065_br)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).build(consumer, this.sieveLoc("blaze_powder"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_END_STONE.get()})).addResult((IItemProvider)Items.field_151079_bi)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.005f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.01f)).addRoll(new MeshWithChance(EnumMesh.EMERALD, 0.015f)).addRoll(new MeshWithChance(EnumMesh.NETHERITE, 0.02f)).build(consumer, this.sieveLoc("ender_pearl"));
        block4: for (EnumOre enumOre : EnumOre.values()) {
            switch (enumOre) {
                case IRON: {
                    this.registerIronOres(consumer, enumOre);
                    continue block4;
                }
                case GOLD: {
                    this.registerGoldOres(consumer, enumOre);
                    continue block4;
                }
                default: {
                    this.registerDefaultOres(consumer, enumOre);
                }
            }
        }
        for (Enum enum_ : EnumSeed.values()) {
            if (enum_ != EnumSeed.SEED_PICKLE && enum_ != EnumSeed.SEED_KELP) {
                ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)((EnumSeed)enum_).getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).build(consumer, this.sieveLoc(((EnumSeed)enum_).getSeedName()));
                continue;
            }
            ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)((EnumSeed)enum_).getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc(((EnumSeed)enum_).getSeedName()));
        }
        this.getLeavesSaplings().forEach((input, drop) -> {
            if (input.getRegistryName().equals((Object)new ResourceLocation("jungle_leaves"))) {
                ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input})).addResult((IItemProvider)drop)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.025f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.075f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.1f)).build(consumer, this.sieveLoc(input.getRegistryName().func_110623_a()));
            } else {
                ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input})).addResult((IItemProvider)drop)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.1f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.15f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.2f)).build(consumer, this.sieveLoc(input.getRegistryName().func_110623_a()));
            }
        });
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).addResult((IItemProvider)Items.field_151034_e)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.1f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.15f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.2f)).build(consumer, this.sieveLoc("apple"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).addResult((IItemProvider)Items.field_151153_ao)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.001f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.003f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.005f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.01f)).build(consumer, this.sieveLoc("golden_apple"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).addResult((IItemProvider)EnumResource.SILKWORM.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.025f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.1f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.2f)).build(consumer, this.sieveLoc("silkworm"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.BLUE_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_blue_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.PURPLE_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_purple_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.PINK_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_pink_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.YELLOW_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_yellow_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.RED_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_red_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_221600_aB)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seagrass"));
    }
}

