/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.datagen;

import net.minecraft.block.Block;
import net.minecraft.block.CakeBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import novamachina.exnihilosequentia.api.datagen.AbstractBlockStateGenerator;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloFluids;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;

public class ExNihiloBlockStateGenerator
extends AbstractBlockStateGenerator {
    public ExNihiloBlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "exnihilosequentia", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerSimpleBlocks();
        this.registerSieves();
        this.registerBarrels();
        this.registerCrucibles();
        this.registerCake();
        this.registerFluids();
    }

    private String getRegistryName(Block b) {
        return b.getRegistryName().toString();
    }

    private void registerBarrel(Block block, ResourceLocation texture) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.modLoc("block/barrel"))).texture("texture", texture)).texture("particle", texture));
        this.simpleItemBlock(block, model.model);
    }

    private void registerBarrels() {
        this.registerBarrel((Block)ExNihiloBlocks.BARREL_STONE.get(), new ResourceLocation("minecraft", "block/stone"));
        this.registerBarrel((Block)ExNihiloBlocks.BARREL_WOOD.get(), new ResourceLocation("minecraft", "block/oak_planks"));
    }

    private void registerCake() {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)ExNihiloBlocks.END_CAKE.get());
        for (int i = 1; i < 7; ++i) {
            VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
            ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("exnihilosequentia:block/cake_slice" + i)));
            partialBlockstate.with((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{model});
        }
        VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
        ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("exnihilosequentia:block/cake_uneaten")));
        partialBlockstate.with((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{model});
    }

    private void registerCrucible(Block block, ResourceLocation texture) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.modLoc("block/crucible"))).texture("particle", texture)).texture("top", texture)).texture("bottom", texture)).texture("side", texture)).texture("inside", texture));
        this.simpleItemBlock(block, model.model);
    }

    private void registerCrucibles() {
        this.registerCrucible((Block)ExNihiloBlocks.CRUCIBLE_FIRED.get(), new ResourceLocation("exnihilosequentia", "block/crucible_fired"));
        this.registerCrucible((Block)ExNihiloBlocks.CRUCIBLE_UNFIRED.get(), new ResourceLocation("exnihilosequentia", "block/crucible_unfired"));
        this.registerCrucible((Block)ExNihiloBlocks.CRUCIBLE_WOOD.get(), new ResourceLocation("minecraft", "block/oak_log"));
    }

    private void registerFluids() {
        this.registerFluid((Fluid)ExNihiloFluids.WITCH_WATER.get());
        this.registerFluid((Fluid)ExNihiloFluids.SEA_WATER.get());
    }

    private void registerSieve(Block block, ResourceLocation texture) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.modLoc("block/sieve_base"))).texture("texture", texture)).texture("particle", texture));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        MultiPartBlockStateBuilder.PartBuilder partBuilder = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model.model).addModel();
        partBuilder.end();
        for (EnumMesh mesh : EnumMesh.values()) {
            if (mesh == EnumMesh.NONE) continue;
            partBuilder = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.ExistingModelFile(new ResourceLocation("exnihilosequentia", "block/" + mesh.getMeshName()), this.models().existingFileHelper)).addModel();
            partBuilder.condition(BlockSieve.MESH, (Comparable[])new EnumMesh[]{mesh});
            partBuilder.end();
        }
        this.simpleBlockItem(block, model.model);
    }

    private void registerSieves() {
        this.registerSieve((Block)ExNihiloBlocks.SIEVE.get(), new ResourceLocation("minecraft", "block/oak_planks"));
    }

    private void registerSimpleBlocks() {
        this.basicBlock((Block)ExNihiloBlocks.CRUSHED_ANDESITE.get());
        this.basicBlock((Block)ExNihiloBlocks.CRUSHED_DIORITE.get());
        this.basicBlock((Block)ExNihiloBlocks.CRUSHED_GRANITE.get());
        this.basicBlock((Block)ExNihiloBlocks.CRUSHED_NETHERRACK.get());
        this.basicBlock((Block)ExNihiloBlocks.CRUSHED_END_STONE.get());
        this.basicBlock((Block)ExNihiloBlocks.DUST.get());
        this.basicBlock((Block)ExNihiloBlocks.INFESTED_LEAVES.get());
        this.basicBlock((Block)ExNihiloBlocks.INFESTING_LEAVES.get());
    }
}

