/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.api.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.common.item.tools.hammer.EnumHammer;

public class HammerRecipeSerializer
extends RecipeSerializer<HammerRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)EnumHammer.DIAMOND.getRegistryObject().get());
    }

    public HammerRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        int outputCount = buffer.readInt();
        ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            output.add(ItemStackWithChance.read(buffer));
        }
        return new HammerRecipe(recipeId, input, output);
    }

    public void toNetwork(PacketBuffer buffer, HammerRecipe recipe) {
        recipe.getInput().func_199564_a(buffer);
        buffer.writeInt(recipe.getOutput().size());
        for (ItemStackWithChance stack : recipe.getOutput()) {
            stack.write(buffer);
        }
    }

    @Override
    protected HammerRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        JsonArray results = json.getAsJsonArray("results");
        ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            output.add(ItemStackWithChance.deserialize(results.get(i)));
        }
        return new HammerRecipe(recipeId, input, output);
    }
}

