/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public class FluidItemRecipeSerializer
extends RecipeSerializer<FluidItemRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_WOOD.get());
    }

    public FluidItemRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidStack fluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack output = buffer.func_150791_c();
        return new FluidItemRecipe(recipeId, fluid, input, output);
    }

    public void toNetwork(PacketBuffer buffer, FluidItemRecipe recipe) {
        recipe.getFluidInBarrel().writeToPacket(buffer);
        recipe.getInput().func_199564_a(buffer);
        buffer.func_150788_a(recipe.func_77571_b());
    }

    @Override
    protected FluidItemRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidStack fluid = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluid").getAsJsonObject());
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        ItemStack result = this.readOutput(json.get("result"));
        return new FluidItemRecipe(recipeId, fluid, input, result);
    }
}

