/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public class CrucibleRecipeSerializer
extends RecipeSerializer<CrucibleRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_FIRED.get());
    }

    public CrucibleRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        int amount = buffer.readInt();
        FluidStack fluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        CrucilbeTypeEnum type = (CrucilbeTypeEnum)buffer.func_179257_a(CrucilbeTypeEnum.class);
        return new CrucibleRecipe(recipeId, input, amount, fluid, type);
    }

    public void toNetwork(PacketBuffer buffer, CrucibleRecipe recipe) {
        recipe.getInput().func_199564_a(buffer);
        buffer.writeInt(recipe.getAmount());
        recipe.getResultFluid().writeToPacket(buffer);
        buffer.func_179249_a((Enum)recipe.getCrucibleType());
    }

    @Override
    protected CrucibleRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        int amount = json.get("amount").getAsInt();
        FluidStack fluid = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluidResult").getAsJsonObject());
        CrucilbeTypeEnum typeEnum = CrucilbeTypeEnum.getTypeByName(json.get("crucibleType").getAsString());
        return new CrucibleRecipe(recipeId, input, amount, fluid, typeEnum);
    }
}

