/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.sieve.dry;

import com.google.common.collect.HashMultiset;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.api.compat.jei.JEISieveRecipe;
import novamachina.exnihilosequentia.api.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.item.mesh.MeshItem;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class DrySieveRecipeCategory
implements IRecipeCategory<JEISieveRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "dry_sieve");
    private static final ResourceLocation texture = new ResourceLocation("exnihilosequentia", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public DrySieveRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public Class<? extends JEISieveRecipe> getRecipeClass() {
        return JEISieveRecipe.class;
    }

    public String getTitle() {
        return "Sieve";
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(JEISieveRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getResults());
    }

    public void setRecipe(IRecipeLayout recipeLayout, final JEISieveRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 38);
        recipeLayout.getItemStacks().set(0, recipe.getMesh());
        recipeLayout.getItemStacks().init(1, true, 10, 2);
        recipeLayout.getItemStacks().set(1, recipe.getSieveables());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 2;
        for (int i = 0; i < recipe.getResults().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack outputStack = recipe.getResults().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            if (focus == null) continue;
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack.func_190926_b() || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            recipeLayout.getItemStacks().setBackground(slotIndex + i, (IDrawable)this.slotHighlight);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            @OnlyIn(value=Dist.CLIENT)
            public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
                if (!input) {
                    HashMultiset condensedTooltips = HashMultiset.create();
                    List<SieveRecipe> drops = ExNihiloRegistries.SIEVE_REGISTRY.getDrops((IItemProvider)recipe.getInputs().get(1).get(0).func_77973_b(), ((MeshItem)recipe.getInputs().get(0).get(0).func_77973_b()).getMesh(), false);
                    for (SieveRecipe entry : drops) {
                        ItemStack drop = entry.getDrop();
                        if (!drop.func_77969_a(ingredient)) continue;
                        for (MeshWithChance meshWithChance : entry.getRolls()) {
                            condensedTooltips.add((Object)StringUtils.formatPercent(Float.valueOf(meshWithChance.getChance())));
                        }
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.sieve.dropChance"));
                    for (String line : condensedTooltips.elementSet()) {
                        tooltip.add((ITextComponent)new StringTextComponent(" * " + condensedTooltips.count((Object)line) + "x " + line));
                    }
                }
            }
        });
    }
}

