/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.heat;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipe;

public class HeatRecipeCategory
implements IRecipeCategory<HeatRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "heat");
    private final IDrawableStatic background;

    public HeatRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 134, 18, 34).addPadding(0, 0, 0, 80).build();
    }

    public void draw(HeatRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, recipe.getAmount() + "X", 24.0f, 12.0f, Color.gray.getRGB());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public Class<? extends HeatRecipe> getRecipeClass() {
        return HeatRecipe.class;
    }

    public String getTitle() {
        return "Crucible Heat Sources";
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(HeatRecipe recipe, IIngredients ingredients) {
        if (ForgeRegistries.FLUIDS.containsKey(recipe.getInput().getRegistryName())) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getInput().getRegistryName()), 1000));
        } else {
            ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{recipe.getInput()}).func_193365_a()));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, HeatRecipe recipe, IIngredients ingredients) {
        if (ForgeRegistries.FLUIDS.containsKey(recipe.getInput().getRegistryName())) {
            recipeLayout.getFluidStacks().init(0, true, 1, 17);
            recipeLayout.getFluidStacks().set(0, new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getInput().getRegistryName()), 1000));
        } else {
            Block input = recipe.getInput();
            if (input == Blocks.field_150480_ab || input == Blocks.field_235335_bO_) {
                input = Items.field_151033_d;
            }
            if (input instanceof FlowingFluidBlock) {
                input = ((FlowingFluidBlock)input).getFluid().func_204524_b();
            }
            recipeLayout.getItemStacks().init(0, true, 0, 16);
            recipeLayout.getItemStacks().set(0, Arrays.asList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}).func_193365_a()));
        }
    }
}

