/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.hammer;

import java.util.ArrayList;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.common.compat.jei.hammer.HammerTooltipCallback;

public class HammerRecipeCategory
implements IRecipeCategory<HammerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "hammer");
    private static final ResourceLocation texture = new ResourceLocation("exnihilosequentia", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public HammerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 56, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public Class getRecipeClass() {
        return HammerRecipe.class;
    }

    public String getTitle() {
        return "Hammer";
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(HammerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, new ArrayList<ItemStack>(Arrays.asList(recipe.getInput().func_193365_a())));
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputsWithoutChance());
    }

    public void setRecipe(IRecipeLayout recipeLayout, HammerRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 38);
        recipeLayout.getItemStacks().set(0, new ArrayList<ItemStack>(Arrays.asList(recipe.getInput().func_193365_a())));
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 1;
        for (int i = 0; i < recipe.getOutputsWithoutChance().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack outputStack = recipe.getOutputsWithoutChance().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            if (focus == null) continue;
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack.func_190926_b() || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            recipeLayout.getItemStacks().setBackground(i + slotIndex, (IDrawable)this.slotHighlight);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new HammerTooltipCallback(recipe));
    }
}

