/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.crucible;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.compat.jei.crucible.FiredCrucibleTooltipCallback;
import novamachina.exnihilosequentia.common.compat.jei.crucible.WoodCrucibleTooltipCallback;

public class CrucibleRecipeCategory
implements IRecipeCategory<CrucibleRecipe> {
    private static final ResourceLocation texture = new ResourceLocation("exnihilosequentia", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private final ResourceLocation uid;

    public CrucibleRecipeCategory(IGuiHelper guiHelper, String uid) {
        this.background = guiHelper.createDrawable(texture, 0, 168, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
        this.uid = new ResourceLocation("exnihilosequentia", uid);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public Class<? extends CrucibleRecipe> getRecipeClass() {
        return CrucibleRecipe.class;
    }

    public String getTitle() {
        return "Crucible";
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public void setIngredients(CrucibleRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputs());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getResultFluid());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrucibleRecipe recipe, IIngredients ingredients) {
        recipeLayout.getFluidStacks().init(0, true, 3, 21);
        recipeLayout.getFluidStacks().set(0, recipe.getResultFluid());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 1;
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack stack = recipe.getInputs().get(i);
            recipeLayout.getItemStacks().init(i + slotIndex, true, slotX, slotY);
            recipeLayout.getItemStacks().set(i + slotIndex, stack);
            if (focus == null || !(focus.getValue() instanceof ItemStack) || !stack.func_77969_a((ItemStack)focus.getValue())) continue;
            recipeLayout.getItemStacks().setBackground(i + slotIndex, (IDrawable)this.slotHighlight);
        }
        if (this.uid.equals((Object)new ResourceLocation("exnihilosequentia", "crucible_fired"))) {
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new FiredCrucibleTooltipCallback());
        } else {
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new WoodCrucibleTooltipCallback());
        }
    }
}

