/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.block;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.builder.BlockBuilder;
import novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import novamachina.exnihilosequentia.common.item.mesh.MeshItem;
import novamachina.exnihilosequentia.common.tileentity.SieveTile;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import novamachina.exnihilosequentia.common.utility.StringUtils;
import org.apache.logging.log4j.LogManager;

public class BlockSieve
extends BaseBlock
implements IWaterLoggable,
ITOPInfoProvider {
    public static final EnumProperty<EnumMesh> MESH = EnumProperty.func_177709_a((String)"mesh", EnumMesh.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    public BlockSieve() {
        super(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.7f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235828_a_((state, reader, pos) -> false).func_235842_b_((state, reader, pos) -> false).func_235847_c_((state, reader, pos) -> false)).harvestLevel(ToolType.AXE, 0).tileEntitySupplier(SieveTile::new));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(MESH, (Comparable)((Object)EnumMesh.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void activateBlock(BlockState state, World worldIn, PlayerEntity player, BlockPos pos, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        SieveTile sieveTile = (SieveTile)worldIn.func_175625_s(pos);
        logger.debug("isReadyToSieve: " + sieveTile.isReadyToSieve());
        if (sieveTile.isReadyToSieve()) {
            sieveTile.activateSieve(player, (Boolean)state.func_177229_b((Property)WATERLOGGED));
        }
        if (!sieveTile.isReadyToSieve() && stack.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)stack.func_77973_b();
            logger.debug("Is Block Siftable: " + ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable(blockItem.func_179223_d(), sieveTile.getMesh(), (Boolean)state.func_177229_b((Property)WATERLOGGED)));
            if (ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable(blockItem.func_179223_d(), sieveTile.getMesh(), (Boolean)state.func_177229_b((Property)WATERLOGGED))) {
                sieveTile.insertSiftableBlock(stack, player);
            }
        }
        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        SieveTile sieveTile = (SieveTile)world.func_175625_s(iProbeHitData.getPos());
        if (!sieveTile.getBlockStack().func_190926_b()) {
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf(sieveTile.getProgress() / 1.0f))}));
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.sieve.block", new Object[]{new TranslationTextComponent(sieveTile.getBlockStack().func_77977_a())}));
        }
        if (sieveTile.getMesh() != EnumMesh.NONE) {
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.sieve.mesh", new Object[]{new TranslationTextComponent("item.exnihilosequentia." + sieveTile.getMesh().getMeshName())}));
        }
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return Boolean.TRUE.equals(state.func_177229_b((Property)WATERLOGGED)) ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (!worldIn.func_201670_d() && te instanceof SieveTile) {
            ((SieveTile)te).removeMesh(true);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            logger.debug("Sieve Activated");
            SieveTile sieveTile = (SieveTile)worldIn.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(handIn);
            if (player.func_225608_bj_() && stack.func_190926_b()) {
                sieveTile.removeMesh(true);
            }
            for (BlockPos sievePos : this.getNearbySieves(worldIn, pos)) {
                BlockState currentState = worldIn.func_180495_p(sievePos);
                this.activateBlock(currentState, worldIn, player, sievePos, handIn);
            }
            if (stack.func_77973_b() instanceof MeshItem) {
                sieveTile.insertMesh(stack, player);
            }
        }
        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.func_201670_d()) {
            SieveTile sieveTile = (SieveTile)worldIn.func_175625_s(pos);
            sieveTile.setSieveState();
        }
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (Boolean.TRUE.equals(stateIn.func_177229_b((Property)WATERLOGGED))) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MESH, WATERLOGGED});
    }

    private List<BlockPos> getNearbySieves(World world, BlockPos pos) {
        NonNullList nearbySieves = NonNullList.func_191196_a();
        BlockPos.func_218281_b((BlockPos)new BlockPos(pos.func_177958_n() - Config.getSieveRange(), pos.func_177956_o(), pos.func_177952_p() - Config.getSieveRange()), (BlockPos)new BlockPos(pos.func_177958_n() + Config.getSieveRange(), pos.func_177956_o(), pos.func_177952_p() + Config.getSieveRange())).forEach(item -> {
            if (world.func_180495_p(item).func_177230_c() instanceof BlockSieve) {
                nearbySieves.add((Object)new BlockPos((Vector3i)item));
            }
        });
        return nearbySieves;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }
}

