/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import novamachina.exnihilosequentia.client.render.AbstractModBlockRenderer;
import novamachina.exnihilosequentia.client.render.UVLocation;
import novamachina.exnihilosequentia.client.render.VertexLocation;
import novamachina.exnihilosequentia.common.init.ExNihiloTiles;
import novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import novamachina.exnihilosequentia.common.utility.Color;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class BarrelRender
extends AbstractModBlockRenderer<AbstractBarrelTile> {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    public BarrelRender(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static void register() {
        logger.debug("Register barrel renderer");
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ExNihiloTiles.BARREL_WOOD.get()), BarrelRender::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ExNihiloTiles.BARREL_STONE.get()), BarrelRender::new);
    }

    public void render(AbstractBarrelTile tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        float fillAmount;
        TextureAtlasSprite sprite;
        IVertexBuilder builder;
        Color fluidColor;
        ResourceLocation inventoryTexture = tileEntity.getSolidTexture();
        ResourceLocation solidTexture = Blocks.field_196642_W.getRegistryName();
        Fluid fluid = tileEntity.getFluid();
        ResourceLocation fluidTexture = fluid != null ? fluid.getAttributes().getStillTexture() : null;
        Color color = fluidColor = fluid != null ? new Color(fluid.getAttributes().getColor()) : Color.INVALID_COLOR;
        if (fluidTexture != null) {
            builder = buffer.getBuffer(RenderType.func_228645_f_());
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidTexture);
            fillAmount = 0.75f * tileEntity.getFluidProportion() - 0.005f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.25f + fillAmount, 0.9375f), new UVLocation(sprite.func_94209_e(), sprite.func_94210_h()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.25f + fillAmount, 0.9375f), new UVLocation(sprite.func_94212_f(), sprite.func_94210_h()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.25f + fillAmount, 0.0625f), new UVLocation(sprite.func_94212_f(), sprite.func_94206_g()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.25f + fillAmount, 0.0625f), new UVLocation(sprite.func_94209_e(), sprite.func_94206_g()), fluidColor, combinedLightIn);
            matrixStack.func_227865_b_();
        }
        if (inventoryTexture != null) {
            builder = buffer.getBuffer(RenderType.func_228639_c_());
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation(inventoryTexture.func_110624_b(), "block/" + inventoryTexture.func_110623_a()));
            fillAmount = 0.995f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, fillAmount, 0.9375f), new UVLocation(sprite.func_94209_e(), sprite.func_94210_h()), Color.WHITE, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, fillAmount, 0.9375f), new UVLocation(sprite.func_94212_f(), sprite.func_94210_h()), Color.WHITE, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, fillAmount, 0.0625f), new UVLocation(sprite.func_94212_f(), sprite.func_94206_g()), Color.WHITE, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, fillAmount, 0.0625f), new UVLocation(sprite.func_94209_e(), sprite.func_94206_g()), Color.WHITE, combinedLightIn);
            matrixStack.func_227865_b_();
        }
        if (tileEntity.getSolidAmount() > 0) {
            builder = buffer.getBuffer(RenderType.func_228645_f_());
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation(solidTexture.func_110624_b(), "block/" + solidTexture.func_110623_a()));
            Color color2 = this.getBlockColor(solidTexture, tileEntity);
            float fillAmount2 = 0.75f * Math.min(tileEntity.getSolidProportion(), 1.0f) - 0.005f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.25f + fillAmount2, 0.9375f), new UVLocation(sprite.func_94209_e(), sprite.func_94210_h()), color2, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.25f + fillAmount2, 0.9375f), new UVLocation(sprite.func_94212_f(), sprite.func_94210_h()), color2, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.9375f, 0.25f + fillAmount2, 0.0625f), new UVLocation(sprite.func_94212_f(), sprite.func_94206_g()), color2, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0625f, 0.25f + fillAmount2, 0.0625f), new UVLocation(sprite.func_94209_e(), sprite.func_94206_g()), color2, combinedLightIn);
            matrixStack.func_227865_b_();
        }
    }

    private Color getBlockColor(ResourceLocation solidTexture, AbstractBarrelTile tileEntity) {
        if (solidTexture != null && solidTexture.toString().contains("leaves")) {
            return new Color(tileEntity.func_145831_w().func_226691_t_(tileEntity.func_174877_v()).func_225527_a_());
        }
        return Color.WHITE;
    }
}

