/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.datagen;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.block.ComposterBlock;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;

public abstract class AbstractRecipeGenerator
extends RecipeProvider {
    protected static final String CHUNK_CONDITION = "has_chunk";
    private final String modId;

    protected AbstractRecipeGenerator(DataGenerator generator, String modId) {
        super(generator);
        this.modId = modId;
    }

    @Nonnull
    public String func_200397_b() {
        return "Recipes: " + this.modId;
    }

    protected ResourceLocation compostLoc(String id) {
        return new ResourceLocation(this.modId, "compost/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation crookLoc(String id) {
        return new ResourceLocation(this.modId, "crook/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation crucibleLoc(String id) {
        return new ResourceLocation(this.modId, "crucible/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation fluidItemLoc(String id) {
        return new ResourceLocation(this.modId, "fluid_item/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation fluidOnTopLoc(String id) {
        return new ResourceLocation(this.modId, "fluid_on_top/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation fluidTransformLoc(String id) {
        return new ResourceLocation(this.modId, "fluid_transform/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation hammerLoc(String id) {
        return new ResourceLocation(this.modId, "hammer/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation heatLoc(String id) {
        return new ResourceLocation(this.modId, "heat/" + this.prependRecipePrefix(id));
    }

    protected void registerOre(EnumOre ore, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ore.getChunkItem().get())).func_200472_a("xx").func_200472_a("xx").func_200462_a(Character.valueOf('x'), (IItemProvider)ore.getPieceItem().get()).func_200473_b(this.modId).func_200465_a("has_piece", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getPieceItem().get()})).func_200467_a(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ore.getChunkName())));
    }

    protected void registerSmelting(EnumOre ore, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)(ore.getIngotItem() != null ? ore.getIngotItem() : (IItemProvider)ore.getIngotRegistryItem().get()), (float)0.7f, (int)200).func_218628_a(CHUNK_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ore.getIngotName())));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)(ore.getIngotItem() != null ? ore.getIngotItem() : (IItemProvider)ore.getIngotRegistryItem().get()), (float)0.7f, (int)100).func_218628_a(CHUNK_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix("blast_" + ore.getIngotName())));
    }

    protected ResourceLocation sieveLoc(String id) {
        return new ResourceLocation(this.modId, "sieve/" + this.prependRecipePrefix(id));
    }

    protected String prependRecipePrefix(String id) {
        return "ens_" + id;
    }

    protected ResourceLocation createSaveLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), this.prependRecipePrefix(location.func_110623_a()));
    }

    public static void createMCCompost(IItemProvider item, float chance) {
        ComposterBlock.field_220299_b.put((Object)item, chance);
    }
}

