/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.crafting.sieve;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;

public class MeshWithChance {
    private static final String CHANCE_KEY = "chance";
    private static final String MESH_KEY = "mesh";
    private final float chance;
    private final EnumMesh mesh;

    public MeshWithChance(EnumMesh mesh, float chance) {
        this.mesh = mesh;
        this.chance = chance;
    }

    public static MeshWithChance deserialize(JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(MESH_KEY)) {
            float chance = JSONUtils.func_151221_a((JsonObject)json.getAsJsonObject(), (String)CHANCE_KEY, (float)1.0f);
            EnumMesh mesh = EnumMesh.getMeshFromName(JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)MESH_KEY));
            return new MeshWithChance(mesh, chance);
        }
        EnumMesh mesh = EnumMesh.getMeshFromName(JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)MESH_KEY));
        return new MeshWithChance(mesh, 1.0f);
    }

    public static MeshWithChance read(PacketBuffer buffer) {
        EnumMesh mesh = (EnumMesh)buffer.func_179257_a(EnumMesh.class);
        float chance = buffer.readFloat();
        return new MeshWithChance(mesh, chance);
    }

    public float getChance() {
        return this.chance;
    }

    public EnumMesh getMesh() {
        return this.mesh;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty(CHANCE_KEY, (Number)Float.valueOf(this.getChance()));
        json.addProperty(MESH_KEY, this.getMesh().getName());
        return json;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.getMesh());
        buffer.writeFloat(this.getChance());
    }
}

