/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackWithChance {
    private static final String BASE_KEY = "item";
    private static final String CHANCE_KEY = "chance";
    private static final String COUNT_KEY = "count";
    private final float chance;
    private final ItemStack itemStack;

    public ItemStackWithChance(ItemStack itemStack, float chance) {
        this.itemStack = itemStack;
        this.chance = chance;
    }

    public static ItemStackWithChance deserialize(JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(BASE_KEY)) {
            float chance = JSONUtils.func_151221_a((JsonObject)json.getAsJsonObject(), (String)CHANCE_KEY, (float)1.0f);
            String itemString = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)BASE_KEY);
            int count = 1;
            if (json.getAsJsonObject().has(COUNT_KEY)) {
                count = json.getAsJsonObject().get(COUNT_KEY).getAsInt();
            }
            return new ItemStackWithChance(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString)), count), chance);
        }
        String itemString = JSONUtils.func_151206_a((JsonElement)json, (String)BASE_KEY);
        return new ItemStackWithChance(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString))), 1.0f);
    }

    public static ItemStackWithChance read(PacketBuffer buffer) {
        ItemStack stack = buffer.func_150791_c();
        float chance = buffer.readFloat();
        return new ItemStackWithChance(stack, chance);
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getStack() {
        return this.itemStack.func_77946_l();
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty(CHANCE_KEY, (Number)Float.valueOf(this.getChance()));
        json.addProperty(BASE_KEY, this.getStack().func_77973_b().getRegistryName().toString());
        json.addProperty(COUNT_KEY, (Number)this.getStack().func_190916_E());
        return json;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150788_a(this.getStack());
        buffer.writeFloat(this.getChance());
    }
}

