/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.api.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public abstract class ExNihiloFinishedRecipe<R extends ExNihiloFinishedRecipe<R>>
implements IFinishedRecipe {
    protected JsonArray conditions = null;
    protected JsonArray inputArray = null;
    protected int inputCount = 0;
    protected int maxInputCount = 1;
    protected int maxOutputCount = 1;
    protected JsonArray outputArray = null;
    protected int outputCount = 0;
    private ResourceLocation id;
    private final RecipeSerializer<?> serializer;
    private final List<Consumer<JsonObject>> writerFunctions;

    protected ExNihiloFinishedRecipe(RecipeSerializer<?> serializer) {
        this.serializer = serializer;
        this.writerFunctions = new ArrayList<Consumer<JsonObject>>();
    }

    public R addFluid(String id, FluidStack fluidStack) {
        return this.addWriter(jsonObject -> jsonObject.add(id, FluidStackUtils.jsonSerializeFluidStack(fluidStack)));
    }

    public R addResult(ItemStack itemStack) {
        if (this.outputArray != null) {
            return this.addMultiResult((JsonElement)this.serializeItemStack(itemStack));
        }
        return this.addItem("result", itemStack);
    }

    public R addResult(IItemProvider result) {
        return this.addResult(new ItemStack(result));
    }

    public R addWriter(Consumer<JsonObject> writer) {
        Preconditions.checkArgument((this.id == null ? 1 : 0) != 0, (Object)"This recipe has already been finalized.");
        this.writerFunctions.add(writer);
        return (R)this;
    }

    public void build(Consumer<IFinishedRecipe> out, ResourceLocation id) {
        Preconditions.checkArgument((boolean)this.isComplete(), (Object)"This recipe is incomplete.");
        this.id = id;
        out.accept(this);
    }

    public ResourceLocation func_200443_d() {
        return null;
    }

    public JsonObject func_200440_c() {
        return null;
    }

    public ResourceLocation func_200442_b() {
        return this.id;
    }

    public IRecipeSerializer<?> func_218609_c() {
        return this.serializer;
    }

    public void func_218610_a(JsonObject json) {
        for (Consumer<JsonObject> writer : this.writerFunctions) {
            writer.accept(json);
        }
    }

    public R setMultipleResults(int maxResultCount) {
        this.outputArray = new JsonArray();
        this.maxOutputCount = maxResultCount;
        return this.addWriter(jsonObject -> jsonObject.add("results", (JsonElement)this.outputArray));
    }

    protected R addBlock(Block block) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("block", block.getRegistryName().toString()));
    }

    protected R addBoolean(String key, boolean value) {
        return this.addWriter(jsonObject -> jsonObject.addProperty(key, Boolean.valueOf(value)));
    }

    protected R addFluid(Fluid fluid) {
        return this.addFluid("fluid", new FluidStack(fluid, 1000));
    }

    protected R addFluid(String id, Fluid fluid) {
        return this.addFluid(id, new FluidStack(fluid, 1000));
    }

    protected R addInput(ItemStack input) {
        if (this.inputArray != null) {
            return this.addMultiInput((JsonElement)this.serializeItemStack(input));
        }
        return this.addItem("input", input);
    }

    protected R addInput(Ingredient input) {
        return this.addInput("input", input);
    }

    protected R addInput(String key, Ingredient input) {
        if (this.inputArray != null) {
            return this.addMultiInput(input.func_200304_c());
        }
        return this.addItem(key, input);
    }

    protected R addInput(IItemProvider input) {
        return this.addInput(new ItemStack(input));
    }

    protected R addInput(ITag.INamedTag<Item> tag) {
        return this.addInput(Ingredient.func_199805_a(tag));
    }

    protected R addInput(String id, IItemProvider block) {
        return this.addItem(id, new ItemStack(block));
    }

    protected R addResult(ItemStackWithChance itemStack) {
        if (this.outputArray != null) {
            return this.addMultiResult(itemStack.serialize());
        }
        return this.addItem("result", itemStack.serialize());
    }

    protected boolean isComplete() {
        return true;
    }

    private R addItem(String key, ItemStack itemStack) {
        Preconditions.checkArgument((!itemStack.func_190926_b() ? 1 : 0) != 0, (Object)"ItemStack cannot be empty.");
        return this.addWriter(jsonObj -> jsonObj.add(key, (JsonElement)this.serializeItemStack(itemStack)));
    }

    private R addItem(String key, Ingredient ingredient) {
        return this.addWriter(jsonObj -> jsonObj.add(key, ingredient.func_200304_c()));
    }

    private R addItem(String key, JsonElement obj) {
        return this.addWriter(jsonObj -> jsonObj.add(key, obj));
    }

    private R addMultiInput(JsonElement obj) {
        Preconditions.checkArgument((this.maxInputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple inputs.");
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("This recipe can only have " + this.maxInputCount + "inputs."));
        this.inputArray.add(obj);
        ++this.inputCount;
        return (R)this;
    }

    private R addMultiResult(JsonElement obj) {
        Preconditions.checkArgument((this.maxOutputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple results.");
        Preconditions.checkArgument((this.outputCount < this.maxOutputCount ? 1 : 0) != 0, (Object)("This recipe can only have " + this.maxOutputCount + "results."));
        this.outputArray.add(obj);
        ++this.outputCount;
        return (R)this;
    }

    private JsonObject serializeItemStack(ItemStack itemStack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", itemStack.func_77973_b().getRegistryName().toString());
        if (itemStack.func_190916_E() > 1) {
            obj.addProperty("count", (Number)itemStack.func_190916_E());
        }
        if (itemStack.func_77942_o()) {
            obj.addProperty("nbt", itemStack.func_77978_p().toString());
        }
        return obj;
    }
}

